/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.uploader;

import com.aliyun.Context;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.utils.CommonUtils;
import java.util.concurrent.TimeUnit;

public class OssUploadProgressListener
implements ProgressListener {
    private static final long UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private long bytesWritten = 0L;
    private long totalBytes;
    private long lastPrint = 0L;

    OssUploadProgressListener(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    private void output(String content) {
        if (CommonUtils.isNotEmpty(Context.getLogger())) {
            Context.getLogger().info((CharSequence)content);
        } else {
            System.out.println(content);
        }
    }

    private void printPercentage(int percent, String suffix) {
        System.out.print("\r");
        StringBuilder bar = new StringBuilder("[");
        for (int i = 0; i < 50; ++i) {
            bar.append(i * 2 < percent ? "#" : ".");
        }
        System.out.print("\r" + bar + "] " + percent + "%" + suffix);
        System.out.flush();
    }

    public void progressChanged(ProgressEvent progressEvent) {
        long bytes = progressEvent.getBytes();
        ProgressEventType eventType = progressEvent.getEventType();
        switch (eventType) {
            case TRANSFER_STARTED_EVENT: {
                this.output("Start to upload......");
                this.lastPrint = System.currentTimeMillis();
                break;
            }
            case REQUEST_BYTE_TRANSFER_EVENT: {
                this.bytesWritten += bytes;
                long now = System.currentTimeMillis();
                if (now - this.lastPrint < UPDATE_INTERVAL && this.bytesWritten != this.totalBytes) break;
                this.lastPrint = now;
                int percent = (int)((double)this.bytesWritten * 100.0 / (double)this.totalBytes);
                String suffix = " (" + this.bytesWritten + "/" + this.totalBytes + ")";
                this.printPercentage(percent, suffix);
                break;
            }
            case TRANSFER_COMPLETED_EVENT: {
                System.out.println();
                this.output("\nSucceed to upload, " + this.bytesWritten + " bytes have been uploaded.");
                break;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(System.getenv());
    }
}

