/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.utils;

import com.aliyun.Context;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.edas.model.v20170801.GetChangeOrderInfoRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpUtils {
    private static final List<String> RETRY_ERROR_CODE_LIST = Arrays.asList("500", "503");
    private static final AtomicInteger INCR = new AtomicInteger();

    public static <RESPONSE extends AcsResponse> RESPONSE getAcsResponseIfRetry(IAcsClient client, AcsRequest<RESPONSE> request) throws ClientException {
        AcsResponse response = null;
        int retryCount = 0;
        if (!(request instanceof GetChangeOrderInfoRequest)) {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            Context.getLogger().info((CharSequence)("request[" + INCR.incrementAndGet() + "] = " + request.getClass().getSimpleName() + "\n" + jsonMapper.writeValueAsString(request) + "\n"));
        }
        do {
            try {
                request.setSysConnectTimeout(Integer.valueOf(5000));
                request.setSysReadTimeout(Integer.valueOf(5000));
                response = client.getAcsResponse(request);
            }
            catch (ServerException e) {
                if (RETRY_ERROR_CODE_LIST.contains(e.getErrCode())) {
                    Thread.sleep(3000L);
                }
                Context.getLogger().warn((CharSequence)String.format("%s server error retryCount(%d). msg=(%s)", request.getClass().getSimpleName(), retryCount, e.toString()), (Throwable)e);
            }
            catch (ClientException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    Context.getLogger().warn((CharSequence)String.format("%s error retryCount(%d). msg=(%s)", request.getClass().getSimpleName(), ++retryCount, e.toString()));
                    continue;
                }
                throw e;
            }
        } while (response == null);
        return (RESPONSE)response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void postJson(String url, String body, int defaultTimeout) {
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(defaultTimeout).setConnectionRequestTimeout(defaultTimeout).setSocketTimeout(defaultTimeout).build();
            client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)httpPost);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            HttpUtils.close(client);
            catch (Throwable throwable2) {
                HttpUtils.close(response);
                HttpUtils.close(client);
                throw throwable2;
            }
        }
        HttpUtils.close((Closeable)response);
        HttpUtils.close((Closeable)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void postPlainText(String url, String body, int defaultTimeout) {
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(defaultTimeout).setConnectionRequestTimeout(defaultTimeout).setSocketTimeout(defaultTimeout).build();
            client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body);
            httpPost.setHeader("Content-type", "text/plain");
            httpPost.setEntity((HttpEntity)entity);
            response = client.execute((HttpUriRequest)httpPost);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            HttpUtils.close(client);
            catch (Throwable throwable2) {
                HttpUtils.close(response);
                HttpUtils.close(client);
                throw throwable2;
            }
        }
        HttpUtils.close((Closeable)response);
        HttpUtils.close((Closeable)client);
    }

    private static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

