/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.ChangeOrderTraceState;
import com.aliyun.enums.Status;
import com.aliyun.utils.CommonUtils;
import com.aliyun.utils.HttpUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.edas.model.v20170801.GetChangeOrderInfoRequest;
import com.aliyuncs.edas.model.v20170801.GetChangeOrderInfoResponse;
import com.aliyuncs.exceptions.ClientException;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ChangeOrderManager {
    private Log logger = Context.getLogger();
    private ChangeOrderTraceState curTraceState = new ChangeOrderTraceState();
    private int serviceStageTimeout;
    private int instanceStageTimeout;
    private boolean sendMsgFailedScheduling = false;

    public void trace(DefaultAcsClient defaultAcsClient, String changeOrderId, int serviceStageTimeout, int instanceStageTimeout) throws Exception {
        boolean finish;
        this.serviceStageTimeout = serviceStageTimeout;
        this.instanceStageTimeout = instanceStageTimeout;
        this.logger.info((CharSequence)("Begin to trace change order: " + changeOrderId));
        while (!(finish = this.trace0(defaultAcsClient, changeOrderId))) {
            this.sleep(5000L);
        }
    }

    private boolean trace0(DefaultAcsClient defaultAcsClient, String changeOrderId) throws Exception {
        GetChangeOrderInfoRequest request = new GetChangeOrderInfoRequest();
        request.setChangeOrderId(changeOrderId);
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
        }
        ChangeOrderTraceState beforeState = this.curTraceState.clone();
        try {
            GetChangeOrderInfoResponse response = (GetChangeOrderInfoResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request);
            if (response.getCode() == 200) {
                boolean finish = this.handleSuccessResponse(response);
                if (finish) {
                    return true;
                }
            } else {
                String msg = String.format("Failed to get change order info, code:%d, message:%s", response.getCode(), response.getMessage());
                this.logger.error((CharSequence)msg);
            }
        }
        catch (ClientException ex) {
            String msg = "Failed to get change order info: " + ex.getMessage();
            this.logger.error((CharSequence)msg);
        }
        if (beforeState.equals(this.curTraceState)) {
            this.logger.info((CharSequence)"Waiting...");
        }
        return false;
    }

    private boolean handleSuccessResponse(GetChangeOrderInfoResponse response) throws Exception {
        GetChangeOrderInfoResponse.ChangeOrderInfo orderInfo = response.getChangeOrderInfo();
        List pipelineInfos = orderInfo.getPipelineInfoList();
        while (this.curTraceState.getPipelineCounter() < pipelineInfos.size()) {
            int beforePipelineCounter = this.curTraceState.getPipelineCounter();
            this.showPipeline((GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo)pipelineInfos.get(this.curTraceState.getPipelineCounter()));
            if (beforePipelineCounter != this.curTraceState.getPipelineCounter()) continue;
            break;
        }
        if (this.isEndStatus(orderInfo.getStatus())) {
            Status status = Status.getByVal(orderInfo.getStatus());
            switch (status) {
                case SUCCESS: {
                    this.logger.info((CharSequence)"Deploy application successfully!");
                    return true;
                }
                case EXCEPTION: {
                    throw new Exception("Deploy failed due to exception");
                }
                case FAIL: {
                    throw new Exception("Deploy failed");
                }
                case ABORT: {
                    throw new Exception("Deploy failed due to abort");
                }
            }
            throw new Exception("Deploy failed for unknown reason.");
        }
        return false;
    }

    private void showPipeline(GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo pipelineInfo) throws Exception {
        if (!this.curTraceState.isHadPrintPipelineInfo()) {
            String pipelineId = pipelineInfo.getPipelineId();
            String pipelineName = pipelineInfo.getPipelineName();
            this.logger.info((CharSequence)String.format("PipelineName:%s, PipelineId:%s", pipelineName, pipelineId));
            this.curTraceState.setHadPrintPipelineInfo(true);
        }
        List stageInfoDTOS = pipelineInfo.getStageList();
        if (this.curTraceState.getStageCounter() < stageInfoDTOS.size()) {
            while (this.curTraceState.getStageCounter() < stageInfoDTOS.size()) {
                int beforeStageCounter = this.curTraceState.getStageCounter();
                this.showStage((GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO)stageInfoDTOS.get(this.curTraceState.getStageCounter()));
                if (beforeStageCounter != this.curTraceState.getStageCounter()) continue;
                break;
            }
        }
        if (this.isSuccessStatus(pipelineInfo.getPipelineStatus())) {
            this.curTraceState.setPipelineCounter(this.curTraceState.getPipelineCounter() + 1);
            this.curTraceState.resetPipelineState();
        }
    }

    private void showStage(GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO stageInfo) throws Exception {
        if (!this.curTraceState.isHadPrintStageInfo()) {
            String stageId = stageInfo.getStageId();
            String stageName = stageInfo.getStageName();
            this.logger.info((CharSequence)String.format("StageName:%s, StageId:%s", stageName, stageId));
            this.curTraceState.setHadPrintStageInfo(true);
        }
        GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO stageResult = stageInfo.getStageResultDTO();
        this.showStageResult(stageResult);
        if (this.isSuccessStatus(stageInfo.getStatus())) {
            this.curTraceState.setStageCounter(this.curTraceState.getStageCounter() + 1);
            this.curTraceState.resetStageState();
        }
    }

    private void showStageResult(GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO stageResult) throws Exception {
        GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO.ServiceStage serviceStage = stageResult.getServiceStage();
        List instances = stageResult.getInstanceDTOList();
        if (serviceStage != null && serviceStage.getStageId() != null) {
            if (!this.curTraceState.isHadPrintServiceStageInfo()) {
                String stageName = serviceStage.getStageName();
                String stageId = serviceStage.getStageId();
                this.logger.info((CharSequence)String.format("ServiceStageName:%s, ServiceStageId:%s", stageName, stageId));
                this.curTraceState.setHadPrintServiceStageInfo(true);
                this.curTraceState.getTimeoutManager().setServiceStageStartTime(System.currentTimeMillis());
            }
            if (this.isSuccessStatus(serviceStage.getStatus())) {
                this.curTraceState.resetServiceStage();
            }
            this.checkBeginEndTimeout(this.curTraceState.getTimeoutManager().getServiceStageStartTime(), System.currentTimeMillis(), this.serviceStageTimeout * 1000, "Time out for waiting serviceStage: " + serviceStage.getStageName());
        }
        if (instances != null && instances.size() > 0) {
            while (this.curTraceState.getInstanceCounter() < instances.size()) {
                int beforeInstanceCounter = this.curTraceState.getInstanceCounter();
                this.showInstance((GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO.InstanceDTO)instances.get(this.curTraceState.getInstanceCounter()));
                if (beforeInstanceCounter != this.curTraceState.getInstanceCounter()) continue;
                break;
            }
        }
    }

    private void checkBeginEndTimeout(long begin, long end, long timeout, String msg) throws Exception {
        if (begin != -1L && end != -1L && end - begin > timeout) {
            throw new Exception(msg);
        }
    }

    private void showInstance(GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO.InstanceDTO instance) throws Exception {
        if (!this.curTraceState.isHadPrintInstanceInfo()) {
            String instanceName = instance.getInstanceName();
            String instanceIp = instance.getInstanceIp();
            this.logger.info((CharSequence)String.format("InstanceName:%s, InstanceIp:%s", instanceName, instanceIp));
            this.curTraceState.setHadPrintInstanceInfo(true);
        }
        List instanceStages = instance.getInstanceStageDTOList();
        if (this.curTraceState.getInstanceStageCounter() < instanceStages.size()) {
            while (this.curTraceState.getInstanceStageCounter() < instanceStages.size()) {
                int beforeInstanceStageCounter = this.curTraceState.getInstanceStageCounter();
                this.showInstanceStage((GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO.InstanceDTO.InstanceStageDTO)instanceStages.get(this.curTraceState.getInstanceStageCounter()));
                if (beforeInstanceStageCounter != this.curTraceState.getInstanceStageCounter()) continue;
                break;
            }
        }
        if (this.isSuccessStatus(instance.getStatus())) {
            this.curTraceState.setInstanceCounter(this.curTraceState.getInstanceCounter() + 1);
            this.curTraceState.resetInstanceState();
        }
    }

    private void showInstanceStage(GetChangeOrderInfoResponse.ChangeOrderInfo.PipelineInfo.StageInfoDTO.StageResultDTO.InstanceDTO.InstanceStageDTO instanceStage) throws Exception {
        if (!this.curTraceState.isHadPrintInstanceStageInfo()) {
            String stageName = instanceStage.getStageName();
            String stageId = instanceStage.getStageId();
            if (stageName != null && !this.sendMsgFailedScheduling && stageName.contains("FailedScheduling")) {
                HttpUtils.postJson("https://open.feishu.cn/open-apis/bot/v2/hook/e8867f8c-709d-4357-84af-aec7090b7ed2", "{\"msg_type\":\"text\",\"content\":{\"text\":\"\u540e\u7aef\u90e8\u7f72\u5f02\u5e38. \u8c03\u5ea6\u5931\u8d25! \u963f\u91cc\u4e91\u5269\u4f59\u5185\u5b58\u6216CPU\u4e0d\u8db3 \"}}", 5000);
                this.sendMsgFailedScheduling = true;
            }
            this.logger.info((CharSequence)String.format("InstanceStageName:%s, InstanceStageId:%s", stageName, stageId));
            this.curTraceState.setHadPrintInstanceStageInfo(true);
            this.curTraceState.getTimeoutManager().setInstanceStageStartTime(System.currentTimeMillis());
        }
        if (this.isSuccessStatus(instanceStage.getStatus())) {
            this.curTraceState.setInstanceStageCounter(this.curTraceState.getInstanceStageCounter() + 1);
            this.curTraceState.resetInstanceStageState();
        }
        this.checkBeginEndTimeout(this.curTraceState.getTimeoutManager().getInstanceStageStartTime(), System.currentTimeMillis(), this.instanceStageTimeout * 1000, "Time out for waiting instanceStage: " + instanceStage.getStageName());
    }

    private boolean isEndStatus(Integer s) {
        Status status = Status.getByVal(s);
        switch (status) {
            case SUCCESS: 
            case EXCEPTION: 
            case FAIL: 
            case ABORT: {
                return true;
            }
        }
        return false;
    }

    private boolean isSuccessStatus(Integer s) {
        return s != null && s.intValue() == Status.SUCCESS.getVal();
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

