/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ProgressMessage;
import com.spotify.docker.client.messages.RegistryAuth;
import java.io.File;
import java.nio.file.Paths;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ImageManager {
    private Log logger = Context.getLogger();

    public String buildAndUploadImage(String dockerfile, String repoAddress, String imageTag, String repoUser, String repoPassword, MavenProject project) throws Exception {
        DefaultDockerClient client = DefaultDockerClient.fromEnv().build();
        this.buildImage((DockerClient)client, dockerfile, repoAddress, imageTag, project);
        this.uploadImage((DockerClient)client, repoAddress, imageTag, repoUser, repoPassword, project);
        return this.getImageName(repoAddress, imageTag);
    }

    private void uploadImage(DockerClient client, String repoAddress, String imageTag, String repoUser, String repoPassword, MavenProject project) throws Exception {
        int index = repoAddress.indexOf("/");
        if (index < 0) {
            throw new Exception("Image repository is not correct: " + repoAddress);
        }
        String server = repoAddress.substring(0, index);
        RegistryAuth registryAuth = RegistryAuth.builder().serverAddress(server).username(repoUser).password(repoPassword).build();
        final ArrayBlockingQueue imageDigestQueue = new ArrayBlockingQueue(1);
        String imageName = this.getImageName(repoAddress, imageTag);
        client.push(imageName, new ProgressHandler(){

            public void progress(ProgressMessage message) throws DockerException {
                if (message.status() != null) {
                    ImageManager.this.logger.info((CharSequence)String.format("%s%s", message.id() != null ? message.id() + ": " : "", message.status()));
                }
                if (message.progress() != null) {
                    ImageManager.this.logger.info((CharSequence)message.progress());
                }
                if (message.digest() != null) {
                    imageDigestQueue.add(message.digest());
                }
            }
        }, registryAuth);
        String imageDigest = (String)imageDigestQueue.poll();
        this.logger.info((CharSequence)String.format("Upload image(%s) to repository successfully, digest is %s", imageName, imageDigest));
    }

    private String buildImage(DockerClient client, String dockerfile, String repoAddress, String imageTag, MavenProject project) throws Exception {
        this.logger.info((CharSequence)"Building image...");
        File baseDir = project.getBasedir();
        this.logger.info((CharSequence)("Use " + dockerfile + " in " + baseDir));
        String imageId = client.build(Paths.get(baseDir.getPath(), new String[0]), this.getImageName(repoAddress, imageTag), dockerfile, new ProgressHandler(){

            public void progress(ProgressMessage progressMessage) throws DockerException {
                if (progressMessage.stream() != null) {
                    ImageManager.this.logger.info((CharSequence)progressMessage.stream().replaceAll("[\r\n]", ""));
                }
            }
        }, new DockerClient.BuildParam[0]);
        this.logger.info((CharSequence)("Build image successfully, image id: " + imageId));
        return imageId;
    }

    private String getImageName(String repoAddress, String imageTag) {
        return repoAddress + ":" + imageTag;
    }
}

