/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.RDataModel;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.utils.HttpUtils;
import com.aliyun.utils.PluginUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.UUID;
import org.apache.maven.plugin.logging.Log;

public class ReportManager {
    private static final String RDATA_REMOTE_URL = "http://toolkit.aliyun.com/stat.html";
    private static final String HOST_IDENTITY_FILE = System.getProperty("user.home") + File.separator + ".cloud_toolkit" + File.separator + "maven_plugin_uuid";
    private Log logger = Context.getLogger();

    public void report(ToolkitProfile toolkitProfile, ToolkitDeployConfig deployConfig, boolean success) {
        try {
            RDataModel model = this.getModel(toolkitProfile, deployConfig, success);
            String jsonStr = this.modelToJson(model);
            String body = jsonStr.substring(1, jsonStr.length() - 1);
            HttpUtils.postPlainText(RDATA_REMOTE_URL, body, 1000);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String modelToJson(RDataModel model) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writeValueAsString((Object)model);
    }

    private RDataModel getModel(ToolkitProfile profile, ToolkitDeployConfig deployConfig, boolean success) {
        RDataModel model = new RDataModel(this.getDeviceId());
        model.setIdeType(RDataModel.IdeType.MAVEN);
        model.setIdeVersion(this.getMavenVersion());
        model.setPluginVersion(PluginUtils.getVersion());
        model.setHasAKSK(true);
        model.setDataVersion("1.0");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("accessKeyId", profile.getAccessKeyId());
        data.put("appId", deployConfig.getSpec().getTarget().getAppId());
        data.put("type", success ? "success" : "fail");
        model.setEvent(new RDataModel.REvent(RDataModel.RecordPoint.EDAS, data));
        return model;
    }

    private String getMavenVersion() {
        try {
            int i;
            String mavenHome = System.getProperty("maven.home");
            if (mavenHome != null && (i = mavenHome.lastIndexOf(File.separator)) != -1) {
                return mavenHome.substring(i + 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown";
    }

    private String getDeviceId() {
        File file = new File(HOST_IDENTITY_FILE);
        if (file.exists()) {
            byte[] encoded = new byte[]{};
            try {
                encoded = Files.readAllBytes(Paths.get(HOST_IDENTITY_FILE, new String[0]));
                return new String(encoded);
            }
            catch (IOException iOException) {
                return UUID.randomUUID().toString();
            }
        }
        UUID uuid = UUID.randomUUID();
        String deviceId = uuid.toString();
        File dir = new File(file.getParent());
        dir.mkdirs();
        try (PrintWriter out = new PrintWriter(HOST_IDENTITY_FILE);){
            out.print(deviceId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return deviceId;
    }
}

