/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.uploader;

import com.aliyun.Context;
import com.aliyun.bean.common.OssProfile;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.uploader.PublicOssUploader;
import com.aliyun.uploader.SaeUploader;
import com.aliyun.uploader.Uploader;
import com.aliyun.uploader.UserOssUploader;
import com.aliyun.utils.CommonUtils;

public class UploaderFactory {
    public static Uploader getUploader(ToolkitProfile toolkitProfile, OssProfile ossProfile, String appId, String packageVersion) throws Exception {
        if (CommonUtils.Product.Sae.name().equalsIgnoreCase(toolkitProfile.getProduct())) {
            String regionId = toolkitProfile.getRegionId();
            return new SaeUploader(regionId, appId, packageVersion);
        }
        if (CommonUtils.isNotEmpty(ossProfile)) {
            if (CommonUtils.isEmpty(CommonUtils.isEmpty(ossProfile.getBucket()))) {
                throw new Exception("You are using private OSS bucket to store package, key or bucket config can not be null.");
            }
            String regionId = CommonUtils.isEmpty(ossProfile.getRegionId()) ? toolkitProfile.getRegionId() : ossProfile.getRegionId();
            Context.getLogger().info((CharSequence)String.format("Using specified OSS bucket to store package, please make sure the bucket %s:%s can be read for public.", regionId, ossProfile.getBucket()));
            String ak = CommonUtils.isEmpty(ossProfile.getAccessKeyId()) ? toolkitProfile.getAccessKeyId() : ossProfile.getAccessKeyId();
            String sk = CommonUtils.isEmpty(ossProfile.getAccessKeySecret()) ? toolkitProfile.getAccessKeySecret() : ossProfile.getAccessKeySecret();
            return new UserOssUploader(toolkitProfile.getEndpoint(), regionId, ossProfile.getBucket(), ossProfile.getKey(), ak, sk, appId, packageVersion, ossProfile.getInternal());
        }
        return new PublicOssUploader(toolkitProfile.getEndpoint(), toolkitProfile.getRegionId(), appId);
    }
}

