/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.uploader;

import com.aliyun.uploader.BaseOssUploader;
import com.aliyun.utils.CommonUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class UserOssUploader
extends BaseOssUploader {
    private static final String NAME = "User OSS Uploader";
    private String regionId;
    private String bucket;
    private String key;
    private String ak;
    private String sk;
    private String appId;
    private String packageVersion;
    private String edasEndpoint;
    private String internal;

    private String generateKey() {
        String yyyy_mm_dd_hh_mm_ss = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(new Date());
        String buildUser = System.getProperty("BUILD_USER", System.getenv("BUILD_USER"));
        if (buildUser == null) {
            buildUser = "";
        }
        buildUser = buildUser.replace(".", "_");
        String ptn = CommonUtils.isEmpty(this.key) ? "{region_id}/{app_id}/{version}" : this.key;
        return ptn.replaceAll("\\{region_id}", this.regionId).replaceAll("\\{app_id}", Objects.toString(this.appId, "").replace(".", "_")).replaceAll("\\{version}", Objects.toString(this.packageVersion, "").replace(".", "_")).replaceAll("\\{timestamp}", yyyy_mm_dd_hh_mm_ss).replaceAll("\\{build_user}", buildUser);
    }

    UserOssUploader(String edasEndpoint, String regionId, String bucket, String key, String ak, String sk, String appId, String packageVersion, String internal) {
        this.edasEndpoint = edasEndpoint;
        this.regionId = regionId;
        this.bucket = bucket;
        this.key = key;
        this.ak = ak;
        this.sk = sk;
        this.appId = appId;
        this.packageVersion = packageVersion;
        this.internal = internal;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String upload(File file) throws Exception {
        return this.doUpload(this.edasEndpoint, this.regionId, this.bucket, this.generateKey(), file, this.ak, this.sk, null, this.internal);
    }
}

