/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.utils;

import com.aliyun.bean.common.ToolkitProfile;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class CommonUtils {
    public static DefaultAcsClient initAcsClient(ToolkitProfile toolkitProfile) throws Exception {
        String product = CommonUtils.isEmpty(toolkitProfile.getProduct()) ? Product.Edas.name() : toolkitProfile.getProduct();
        DefaultProfile.addEndpoint((String)toolkitProfile.getRegionId(), (String)toolkitProfile.getRegionId(), (String)product, (String)toolkitProfile.getEndpoint());
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)toolkitProfile.getRegionId(), (String)toolkitProfile.getAccessKeyId(), (String)toolkitProfile.getAccessKeySecret());
        DefaultAcsClient defaultAcsClient = new DefaultAcsClient((IClientProfile)defaultProfile);
        defaultAcsClient.setAutoRetry(false);
        return defaultAcsClient;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return "".equals(String.valueOf(obj).trim());
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map ? ((Map)obj).isEmpty() : false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !CommonUtils.isEmpty(obj);
    }

    public static String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPopApiRouteKey() {
        if (System.getProperty("X-EDAS-AT-ROUTER-KEY") != null) {
            return System.getProperty("X-EDAS-AT-ROUTER-KEY");
        }
        if (System.getenv("X-EDAS-AT-ROUTER-KEY") != null) {
            return System.getenv("X-EDAS-AT-ROUTER-KEY");
        }
        return null;
    }

    public static enum Product {
        Edas,
        Sae;

    }
}

