/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.common.OssProfile;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.uploader.Uploader;
import com.aliyun.uploader.UploaderFactory;
import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class UploadPackageManager {
    private Log logger;
    private MavenProject project;

    public UploadPackageManager(MavenProject project) {
        this.project = project;
        this.logger = Context.getLogger();
    }

    public String uploadPackage(ToolkitProfile toolkitProfile, OssProfile ossProfile, String appId, String packageVersion) throws Exception {
        return this.doUpload(toolkitProfile, ossProfile, appId, packageVersion);
    }

    private String doUpload(ToolkitProfile toolkitProfile, OssProfile ossProfile, String appId, String packageVersion) throws Exception {
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.exists()) {
            throw new Exception("No artifact is found for: " + this.project.getArtifactId());
        }
        Uploader uploader = UploaderFactory.getUploader(toolkitProfile, ossProfile, appId, packageVersion);
        this.logger.info((CharSequence)String.format("Start to upload [%s] using [%s].", file.getName(), uploader.getName()));
        long st = System.currentTimeMillis();
        String downloadUrl = uploader.upload(file);
        System.out.print("\n");
        this.logger.info((CharSequence)String.format("Upload finished in %s ms, download url: [%s]", System.currentTimeMillis() - st, downloadUrl));
        return downloadUrl;
    }
}

