/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager.deploy;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.manager.AppConfigManager;
import com.aliyun.manager.DeployPackageManager;
import com.aliyun.manager.ImageManager;
import com.aliyun.manager.ReportManager;
import com.aliyun.manager.SaeChangeOrderManager;
import com.aliyun.manager.UploadPackageManager;
import com.aliyun.utils.CommonUtils;
import com.aliyuncs.DefaultAcsClient;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class DeployServerlessManager {
    private Log logger;
    private AppConfigManager appConfigManager;
    private UploadPackageManager uploadPackageManager;
    private ImageManager imageManager;
    private DeployPackageManager deployPackageManager;
    private SaeChangeOrderManager changeOrderManager;
    private ReportManager reportManager = new ReportManager();

    public DeployServerlessManager() {
        this.logger = Context.getLogger();
        this.appConfigManager = new AppConfigManager();
        this.uploadPackageManager = new UploadPackageManager(Context.getProject());
        this.imageManager = new ImageManager();
        this.deployPackageManager = new DeployPackageManager();
        this.changeOrderManager = new SaeChangeOrderManager();
        this.reportManager = new ReportManager();
    }

    public void deploy(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig) throws Exception {
        MavenProject project = Context.getProject();
        DefaultAcsClient defaultAcsClient = Context.getAcsClient();
        this.checkParam(packageConfig);
        this.completeAppConfig(deployConfig, packageConfig, project, defaultAcsClient);
        this.uploadPackage(deployConfig, packageConfig);
        this.buildAndUploadImage(packageConfig, project);
        String changeOrderId = this.deployPackage(deployConfig, packageConfig, defaultAcsClient);
        this.traceChangeOrder(deployConfig, defaultAcsClient, changeOrderId);
        this.report(deployConfig, true);
    }

    private void checkParam(ToolkitPackageConfig packageConfig) throws Exception {
        if (packageConfig.getSpec().getPackageType() == null) {
            throw new Exception("Package type is missed in toolkit package config file.");
        }
        if (!("Image".equalsIgnoreCase(packageConfig.getSpec().getPackageType()) || "War".equalsIgnoreCase(packageConfig.getSpec().getPackageType()) || "FatJar".equalsIgnoreCase(packageConfig.getSpec().getPackageType()))) {
            throw new Exception("Package type should be Image/FatJar/War in toolkit package config file.");
        }
    }

    private void report(ToolkitDeployConfig deployConfig, boolean success) {
        this.reportManager.report(Context.getToolkitProfileConfig(), deployConfig, success);
    }

    private void traceChangeOrder(ToolkitDeployConfig deployConfig, DefaultAcsClient defaultAcsClient, String changeOrderId) throws Exception {
        this.changeOrderManager.trace(defaultAcsClient, changeOrderId, deployConfig.getSpec().getServiceStageTimeout(), deployConfig.getSpec().getInstanceStageTimeout());
    }

    private String deployPackage(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig, DefaultAcsClient defaultAcsClient) throws Exception {
        return this.deployPackageManager.deployPackage(defaultAcsClient, deployConfig, packageConfig);
    }

    private void buildAndUploadImage(ToolkitPackageConfig packageConfig, MavenProject project) throws Exception {
        if (!"Image".equalsIgnoreCase(packageConfig.getSpec().getPackageType())) {
            return;
        }
        if (packageConfig.getSpec().getImageUrl() != null) {
            this.logger.info((CharSequence)"Image url is set, skip building image.");
            return;
        }
        if (packageConfig.getSpec().getBuild() == null) {
            throw new Exception("Failed to build image: imageUrl or Build is not set in toolkit package config file.");
        }
        if (packageConfig.getSpec().getBuild().getDocker() == null) {
            throw new Exception("Failed to build image: imageUrl or Docker is not set in toolkit package config file.");
        }
        if (packageConfig.getSpec().getBuild().getDocker().getImageRepoAddress() == null) {
            throw new Exception("Failed to build image: imageUrl or imageRepoAddress is not set in toolkit package config file.");
        }
        if (packageConfig.getSpec().getBuild().getDocker().getImageTag() == null) {
            throw new Exception("Failed to build image: imageUrl or imageTag is not set in toolkit package config file.");
        }
        String dockerfile = packageConfig.getSpec().getBuild().getDocker().getDockerfile();
        if (dockerfile == null) {
            dockerfile = "Dockerfile";
        }
        this.logger.info((CharSequence)String.format("Use %s to build image in current build repository(%s)", dockerfile, project.getBasedir().getPath()));
        packageConfig.getSpec().setImageUrl(this.imageManager.buildAndUploadImage(dockerfile, packageConfig.getSpec().getBuild().getDocker().getImageRepoAddress(), packageConfig.getSpec().getBuild().getDocker().getImageTag(), packageConfig.getSpec().getBuild().getDocker().getImageRepoUser(), packageConfig.getSpec().getBuild().getDocker().getImageRepoPassword(), project));
    }

    private void completeAppConfig(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig, MavenProject project, DefaultAcsClient defaultAcsClient) throws Exception {
        this.appConfigManager.complete(deployConfig, packageConfig, project, defaultAcsClient);
    }

    private void uploadPackage(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig) throws Exception {
        if ("Image".equalsIgnoreCase(packageConfig.getSpec().getPackageType())) {
            return;
        }
        if (packageConfig.getSpec().getPackageUrl() != null) {
            return;
        }
        ToolkitProfile toolkitProfile = Context.getToolkitProfileConfig();
        String packageVersion = deployConfig.getSpec().getVersion();
        if (packageVersion == null) {
            packageVersion = CommonUtils.getCurrentTime();
        }
        toolkitProfile.setProduct(CommonUtils.Product.Sae.name());
        String appId = null;
        if (CommonUtils.isNotEmpty(deployConfig) && CommonUtils.isNotEmpty(deployConfig.getSpec()) && CommonUtils.isNotEmpty(deployConfig.getSpec().getTarget())) {
            appId = deployConfig.getSpec().getTarget().getAppId();
        }
        String downloadUrl = this.uploadPackageManager.uploadPackage(toolkitProfile, null, appId, packageVersion);
        packageConfig.getSpec().setPackageUrl(downloadUrl);
    }
}

