package com.aliyun.bean;

import java.util.Map;

public class RDataModel {

    public static enum RecordPoint {
        STARTUP, EXCEPTION, DEPLOY, NEWUSER, CODE_ANALYZE, EDAS, EDAS_SERVICE_CONNECT, ACS_DEPLOY
    }

    public RDataModel(String uid) {
        this.uid = uid;
    }

    private String uid;

    private boolean hasAKSK;

    private String dataVersion;

    private String ideVersion;

    private IdeType ideType;

    private String pluginVersion;

    private RecordPoint point;

    private Map<String, String> data;

    public IdeType getIdeType() {
        return ideType;
    }

    public void setIdeType(IdeType ideType) {
        this.ideType = ideType;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isHasAKSK() {
        return hasAKSK;
    }

    public void setHasAKSK(boolean hasAKSK) {
        this.hasAKSK = hasAKSK;
    }

    public String getDataVersion() {
        return dataVersion;
    }

    public void setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
    }

    public String getIdeVersion() {
        return ideVersion;
    }

    public void setIdeVersion(String ideVersion) {
        this.ideVersion = ideVersion;
    }

    public String getPluginVersion() {
        return pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public RecordPoint getPoint() {
        return point;
    }

    public void setPoint(RecordPoint point) {
        this.point = point;
    }

    public Map<String, String> getData() {
        return data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public void setEvent(REvent evt) {
        if (evt == null) {
            this.point = null;
            this.data = null;
        }else {
            this.point = evt.point;
            this.data = evt.data;
        }
    }

    public static class REvent {
        RecordPoint point;
        Map<String, String> data;

        public REvent(RecordPoint point, Map<String, String> data) {
            this.point = point;
            this.data = data;
        }

        public RecordPoint getPoint() {
            return point;
        }

        public void setPoint(RecordPoint point) {
            this.point = point;
        }

        public Map<String, String> getData() {
            return data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }

    }

    public enum IdeType {
        ECLIPSE("eclipse"),
        INTELLIJ("intellij"),
        MAVEN("maven");
        private String type;
        IdeType(String type) {
            this.type = type;
        }
        @Override
        public String toString() {
            return type;
        }
    }

}
