package com.aliyun.bean.config;

import lombok.Data;

@Data
public class DefaultConfigBean {
    private Env env;
    private App app;
    private Oss oss;

    @Data
    public static class Env {
        private String accessKeyId;
        private String accessKeySecret;
        private String regionId;
        @Deprecated
        private String domain; //use endpoint instead
        private String endpoint; //the same as domain, but this is more easy to understand
        private String vpcId;
    }

    @Data
    public static class App {
        //common param
        private String appId;
        private String packageVersion;
        private String imageUrl;
        private Integer batchWaitTime;
        private String type;

        //normal app
        private String desc;
        private String deployType;
        private String warUrl;
        private String groupId;
        private Integer batch;
        private String appEnv;
        private Integer stageTimeout;
        private Integer serviceStageTimeout;
        private Integer instanceStageTimeout;
    }

    @Data
    public static class Oss {
        private String regionId;
        private String bucket;
        private String key;
        private String accessKeyId;
        private String accessKeySecret;
    }
}
