package com.aliyun.bean.config;

import com.aliyun.bean.common.OssProfile;
import com.aliyun.enums.Constants;
import lombok.Data;

/**
 * Describe about application creation. In this bean, we define following entities:
 * apiVersion: xxx
 * kind: AppCreation
 * metadata: xxx
 * spec:
 *   type: serverless | edas_ecs | edas_kubernetes | edas_swam | webx
 *   xxx
 *
 * @author nahai
 */
@Data
public class ToolkitCreateConfig {
    private String apiVersion = Constants.V1;;
    private String kind;
    private String metadata;
    private Spec spec;

    @Data
    public static class Spec {
        private String type;

        //type: serverless
        private String appName;
        private String namespaceId;
        private String appDescription;
        private String vpcId;
        private String vswitchId;
        private Integer cpu;
        private Integer memory;
        private Integer replicas;
        private Boolean withDeploy;
    }
}
