package com.aliyun.bean.config;

import com.aliyun.bean.common.OssProfile;
import com.aliyun.enums.Constants;
import lombok.Data;

import java.util.List;

/**
 * Describe about application deployment. This config is used in toolkit:deploy.
 * This bean is used to replace DefaultConfigBean. In this bean, we define following entities:
 * apiVersion: xxx
 * kind: AppDeployment
 * metadata: xxx
 * spec:
 *   type: serverless | edas_ecs | edas_kubernetes | edas_swam | webx
 *   xxx
 *
 * @author nahai
 */
@Data
public class ToolkitDeployConfig {
    private String apiVersion = Constants.V1;
    private String kind;
    private String metadata;
    private ToolkitDeployConfig.Spec spec;

    @Data
    public static class Spec {
        private String type;
        private Target target;

        private String desc;
        private String version;
        private List<Env> envs;
        private Integer batchWaitTime;
        private String groupId;
        private Integer batch;
        private String jdk;
        private String command;
        private List<String> commandArgs;
        private List<HostAlias> customHostAlias;
        private String jarStartOptions;
        private String jarStartArgs;
        private String liveness;
        private String readiness;
        private Integer minReadyInstances;
        private String webContainer;

        //plugin used param
        private Integer stageTimeout;
        private Integer serviceStageTimeout;
        private Integer instanceStageTimeout;

        /**
         * sdk missing configuration parameters, and does not correspond to a version of the api, here make up
         * https://help.aliyun.com/document_detail/149420.html
         * by wangzihao 2020-04-06
         */
        private String localVolume;
        private String storageType;
        private String updateStrategy;
        private Integer replicas;
        //是否将应用实例分布到多可用区。“true”为是，其他值为否。
        private Boolean deployAcrossZones;
        //是否将应用实例分布到多个节点。“true”为是，其他值为否。
        private Boolean deployAcrossNodes;
        private Integer memoryRequest;
        private Integer memoryLimit;

        private String cpuRequest;
        private String cpuLimit;
        private String mcpuRequest;
        private String mcpuLimit;

        private Boolean enableAhas;
        private String changeOrderDesc;
    }

    @Data
    public static class Exec {
        private List<String> command;
    }

    @Data
    public static class Readiness {
        private Exec exec;
        private Integer initialDelaySeconds;
        private Integer timeoutSeconds;
    }

    @Data
    public static class Liveness {
        private Exec exec;
        private Integer initialDelaySeconds;
        private Integer timeoutSeconds;
    }

    @Data
    public static class HostAlias {
        private String hostName;
        private String ip;
    }

    @Data
    public static class Env {
        public Env(){}
        public Env(String n, String v) {
            name = n;
            value = v;
        }
        private String name;
        private String value;
    }

    @Data
    public static class Target {
        private String appName;
        private String namespaceId;
        private String appId;
    }
}
