package com.aliyun.bean.config;

import com.aliyun.bean.common.BuildProfile;
import com.aliyun.enums.Constants;
import lombok.Data;

/**
 * Describe about application package before deployment. In this bean, we define following entities:
 *
 * apiVersion: xxx
 * kind: AppPackage
 * metadata: xxx
 * spec:
 *   type: serverless | edas_ecs | edas_kubernetes | edas_swam | webx
 *   xxx
 *
 * @author nahai
 */
@Data
public class ToolkitPackageConfig {
    private String apiVersion = Constants.V1;;
    private String kind;
    private String metadata;
    private ToolkitPackageConfig.Spec spec;

    @Data
    public static class Spec {
        private String type;

        private BuildProfile build;
        private String imageUrl;
        private String jdk;
        private String packageType; //Image、War、FatJar、
        private String packageUrl;
    }
}
