package com.aliyun.enums;

public enum Status {
    //0：准备 1：执行中 2：执行成功 3：执行失败 6：终止 10：系统异常执行失败
    UNKNOW(-100),
    PREPARE(0),
    EXECUTING(1),
    SUCCESS(2),
    FAIL(3),
    ABORT(6),
    EXCEPTION(10);

    private int val;
    Status(int val) {
        this.val = val;
    }

    public int getVal() {
        return val;
    }

    public static Status getByVal(Integer val) {
        if (val == null) {
            return UNKNOW;
        }

        for (Status status: Status.values()) {
            if (status.getVal() == val) {
                return status;
            }
        }

        return UNKNOW;
    }
}
