package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.ChangeOrderTraceState;
import com.aliyun.enums.Constants;
import com.aliyun.enums.Status;
import com.aliyun.utils.CommonUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.sae.model.v20190506.*;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class SaeChangeOrderManager {

    private Log logger;
    private ChangeOrderTraceState curTraceState;
//    private int serviceStageTimeout; //秒
//    private int instanceStageTimeout; //秒

    public SaeChangeOrderManager() {
        this.logger = Context.getLogger();
        this.curTraceState = new ChangeOrderTraceState();
    }

    public void trace(
            DefaultAcsClient defaultAcsClient, String changeOrderId,
            int serviceStageTimeout, int instanceStageTimeout) throws Exception {
//        this.serviceStageTimeout = serviceStageTimeout;
//        this.instanceStageTimeout = instanceStageTimeout;

        logger.info("Begin to trace change order: " + changeOrderId);
        for (;;) {
            boolean finish = trace0(defaultAcsClient, changeOrderId);
            if (finish) {
                break;
            }
            sleep(5000);
        }
    }

    private boolean trace0(DefaultAcsClient defaultAcsClient, String changeOrderId) throws Exception {
        DescribeChangeOrderRequest request = new DescribeChangeOrderRequest();
        request.setChangeOrderId(changeOrderId);
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter(Constants.POP_API_ROUTE_KEY, routeKey);
        }

        ChangeOrderTraceState beforeState = curTraceState.clone();
        try {
            DescribeChangeOrderResponse response = com.aliyun.utils.HttpUtils.getAcsResponseIfRetry(defaultAcsClient, request);
            if ("200".equals(response.getCode())) {
                boolean finish = handleSuccessResponse(response);
                if (finish) {
                    return true;
                }
            } else {
                String msg = String.format("Failed to get change order info, code:%s, message:%s",
                        response.getCode(), response.getMessage());
                logger.error(msg);
            }
        } catch (ClientException ex) {
            String msg = "Failed to get change order info: " + ex.getMessage();
            logger.error(msg);
        }

        if (beforeState.equals(curTraceState)) {
            logger.info("Waiting...");
        }

        return false;
    }

    private boolean handleSuccessResponse(DescribeChangeOrderResponse response) throws Exception {
        List<DescribeChangeOrderResponse.Data.Pipeline> pipelineInfos = response.getData().getPipelines();

        while (curTraceState.getPipelineCounter() < pipelineInfos.size()) {
            int beforePipelineCounter = curTraceState.getPipelineCounter();
            showPipeline(pipelineInfos.get(curTraceState.getPipelineCounter()));
            if (beforePipelineCounter == curTraceState.getPipelineCounter()) {
                break;
            }
        }

        if (isEndStatus(response.getData().getStatus())) {
            Status status = Status.getByVal(response.getData().getStatus());
            switch (status) {
                case SUCCESS:
                    logger.info("Deploy application successfully!");
                    return true;
                case EXCEPTION:
                    throw new Exception("Deploy failed due to exception");
                case FAIL:
                    throw new Exception("Deploy failed");
                case ABORT:
                    throw new Exception("Deploy failed due to abort");
                default:
                    throw new Exception("Deploy failed for unknown reason.");
            }
        }

        return false;
    }

    private void showPipeline(DescribeChangeOrderResponse.Data.Pipeline pipelineInfo) throws Exception {
        if (!curTraceState.isHadPrintPipelineInfo()) {
            String pipelineId = pipelineInfo.getPipelineId();
            String pipelineName = pipelineInfo.getPipelineName();
            logger.info(String.format("PipelineName:%s, PipelineId:%s", pipelineName, pipelineId));
            curTraceState.setHadPrintPipelineInfo(true);
        }


        if (isSuccessStatus(pipelineInfo.getStatus())) {
            curTraceState.setPipelineCounter(curTraceState.getPipelineCounter() + 1);
            curTraceState.resetPipelineState();
        }
    }


    private boolean isEndStatus(Integer s) {
        Status status = Status.getByVal(s);
        switch (status) {
            case FAIL:
            case ABORT:
            case SUCCESS:
            case EXCEPTION:
                return true;
            default:
                return false;
        }
    }

    private boolean isSuccessStatus(Integer s) {
        return s != null && s == Status.SUCCESS.getVal();
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        } catch (Exception ex) {
            //ignore
        }
    }
}
