package com.aliyun.manager.config;

import com.aliyun.utils.CommonUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.io.File;

public abstract class AbstractConfigManager<T> {
    private ObjectMapper yamlMapper;
    private ObjectMapper jsonMapper;

    public AbstractConfigManager(boolean snakeCase) {
        //yaml
        yamlMapper = new ObjectMapper(new YAMLFactory());
        if (snakeCase) {
            yamlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        }
        yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        //json
        jsonMapper = new ObjectMapper();
        if (snakeCase) {
            jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        }
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected T load(String configFile, String defaultFile, Class<T> clazz) throws Exception {
        File file;
        if (configFile != null) {
            file = new File(configFile);
        } else {
            file = new File(defaultFile);
        }

        if (!file.exists()) {
            throw new Exception("No config file is found: " + file.getAbsolutePath());
        }

        return yamlMapper.readValue(file, clazz);
    }

    protected T load(String configFile, Class<T> clazz) throws Exception {
        File file = new File(configFile);
        if (!file.exists()) {
            throw new Exception("No config file is found: " + file.getAbsolutePath());
        }

        return yamlMapper.readValue(file, clazz);
    }
}
