package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.bean.config.DefaultConfigBean;
import com.aliyun.exception.ErrMsg;
import com.aliyun.utils.CommonUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;

/**
 * 此类用来加载老版本的配置文件，新版本配置文件使用ToolkitDeployConfigManager加载
 */
@Deprecated
public class DefaultConfigManager extends AbstractConfigManager<DefaultConfigBean> {
    private MavenProject project;
    private Log logger;

    public DefaultConfigManager() {
        super(true);
        this.project = Context.getProject();
        this.logger = Context.getLogger();
    }

    public DefaultConfigBean loadProperties(String configFile, String defaultConfigFile) throws Exception {
        if (configFile != null) {
            return load(configFile, DefaultConfigBean.class);
        }

        if (defaultConfigFile != null && new File(defaultConfigFile).exists()) {
            return load(defaultConfigFile, DefaultConfigBean.class);
        }

        if ("pom".equalsIgnoreCase(project.getPackaging())) {
            throw new Exception(ErrMsg.getPomDeployErrMsg());
        }

        throw new Exception("No edas_config file found for deploy. By default it looks for .edas_config.yaml in current directory.");
    }

    public void checkParamValid(DefaultConfigBean config) throws Exception {
        if (config.getEnv() == null) {
            config.setEnv(new DefaultConfigBean.Env());
        }
        if (config.getApp() == null) {
            config.setApp(new DefaultConfigBean.App());
        }
        DefaultConfigBean.Env env = config.getEnv();
        DefaultConfigBean.App app = config.getApp();
        if (env.getRegionId() == null) {
            throw new Exception("'region_id' is not defined in config file.");
        }
        if (app.getAppId() == null) {
            throw new Exception("'app_id' is not defined in config file.");
        }
    }

}
