package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.config.ToolkitCreateConfig;
import com.aliyun.utils.CommonUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;

public class ToolkitCreateConfigManager extends AbstractConfigManager<ToolkitCreateConfig> {

    private MavenProject project;
    private Log logger;

    public ToolkitCreateConfigManager() {
        super(false);
        this.project = Context.getProject();
        this.logger = Context.getLogger();
    }

    public ToolkitCreateConfig loadProperties(String configFile, String defaultFile) throws MojoExecutionException {

        try {
            return load(configFile, defaultFile, ToolkitCreateConfig.class);
        } catch (Exception ex) {
            logger.error(ex);
            throw new MojoExecutionException(ex.getMessage());
        }
    }
}
