package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.config.ToolkitDeployConfig;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;

public class ToolkitDeployConfigManager extends AbstractConfigManager<ToolkitDeployConfig> {
    private Log logger;
    private MavenProject project;
    private DefaultConfigManager defaultConfigManager;

    public ToolkitDeployConfigManager() {
        super(false);
        this.project = Context.getProject();
        this.logger = Context.getLogger();
        this.defaultConfigManager = new DefaultConfigManager();
    }

    public ToolkitDeployConfig loadProperties(String newFile, String newDefaultFile) throws MojoExecutionException {
        try {
            if (newFile != null) {
                return load(newFile,  ToolkitDeployConfig.class);
            }
            if (newDefaultFile != null) {
                File file = new File(newDefaultFile);
                if (file.exists()) {
                    return load(newDefaultFile, ToolkitDeployConfig.class);
                }
            }
            throw new Exception("No toolkit deploy config is found.");
        } catch (Exception ex) {
            logger.error(ex);
            throw new MojoExecutionException(ex.getMessage());
        }


    }

//    private ToolkitDeployConfig transform(DefaultConfigBean oldConfig) throws Exception {
//        DefaultConfigBean.App app = oldConfig.getApp();
//        if (app == null) {
//            app = new DefaultConfigBean.App();
//            oldConfig.setApp(app);
//        }
//
//        if (app.getAppId() == null) {
//            throw new Exception("app_id is not defined in config file.");
//        }
//
//        ToolkitDeployConfig deployConfig = new ToolkitDeployConfig();
//        deployConfig.setKind(Constants.APP_DEPLOYMENT);
//
//        ToolkitDeployConfig.Spec spec = new ToolkitDeployConfig.Spec();
//        spec.setType("edas");//老版本只有edas
//        spec.setAppId(app.getAppId());
//        spec.setPackageVersion(app.getPackageVersion());
//        spec.setImageUrl(app.getImageUrl());
//        spec.setBatchWaitTime(app.getBatchWaitTime());
//        spec.setDesc(app.getDesc());
//        spec.setDeployType(app.getDeployType());
//        spec.setWarUrl(app.getWarUrl());
//        spec.setGroupId(app.getGroupId());
//        spec.setBatch(app.getBatch());
//        spec.setAppEnv(app.getAppEnv());
//        spec.setStageTimeout(app.getStageTimeout());
//        spec.setServiceStageTimeout(app.getServiceStageTimeout());
//        spec.setInstanceStageTimeout(app.getInstanceStageTimeout());
//        deployConfig.setSpec(spec);
//
//        return deployConfig;
//    }
}
