package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.config.ToolkitPackageConfig;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;

public class ToolkitPackageConfigManager extends AbstractConfigManager<ToolkitPackageConfig> {

    private MavenProject project;
    private Log logger;

    public ToolkitPackageConfigManager() {
        super(false);
        this.project = Context.getProject();
        this.logger = Context.getLogger();
    }

    public ToolkitPackageConfig loadProperties(String configFile, String defaultFile) throws MojoExecutionException {

        try {
            if (configFile != null || new File(defaultFile).exists()) {
                return load(configFile, defaultFile, ToolkitPackageConfig.class);
            }
            throw new Exception("No toolkit package config is found.");
        } catch (Exception ex) {
            logger.error(ex);
            throw new MojoExecutionException(ex.getMessage());
        }
    }
}
