package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.utils.CommonUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;

public class ToolkitProfileConfigManager extends AbstractConfigManager<ToolkitProfile> {

    private MavenProject project;
    private Log logger;

    public ToolkitProfileConfigManager() {
        super(false);
        this.project = Context.getProject();
        this.logger = Context.getLogger();
    }

    public ToolkitProfile loadProperties(
            String configFile, String defaultFile,
            String accessKeyId, String accessKeySecret) throws MojoExecutionException {
        try {
            ToolkitProfile profile = load(configFile, defaultFile, ToolkitProfile.class);
            //check if set by command line
            if (accessKeyId != null && accessKeySecret != null) {
                profile.setAccessKeyId(accessKeyId);
                profile.setAccessKeySecret(accessKeySecret);
                logger.info("Using AK/SK in command line");
            }
            //check if set namespace AS region
            if (profile.getRegionId() != null && profile.getRegionId().contains(":")) {
                logger.warn("You set a namespaceId in toolkit profile, please consider replacing it with a physical region id.");
                int index = profile.getRegionId().indexOf(":");
                profile.setRegionId(profile.getRegionId().substring(0, index));
            }

            //set endpoint
            if (profile.getEndpoint() == null) {
                if (CommonUtils.Product.Edas.name().equalsIgnoreCase(profile.getProduct())) {
                    profile.setEndpoint("edas." + profile.getRegionId() + ".aliyuncs.com");
                } else if (CommonUtils.Product.Sae.name().equalsIgnoreCase(profile.getProduct())) {
                    profile.setEndpoint("sae." + profile.getRegionId() + ".aliyuncs.com");
                } else {
                    logger.warn("Product settings only support edas and sae, using edas as default");
                    profile.setEndpoint("edas." + profile.getRegionId() + ".aliyuncs.com");
                }
            }

            return profile;
        } catch (Exception ex) {
            logger.error(ex);
            throw new MojoExecutionException(ex.getMessage());
        }
    }

}
