package com.aliyun.manager.create;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.bean.config.ToolkitCreateConfig;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.enums.Constants;
import org.apache.maven.plugin.logging.Log;

public class ToolkitCreateManager {
    private Log logger;
    private CreateServerlessManager createServerlessManager;

    public ToolkitCreateManager() {
        logger = Context.getLogger();
        createServerlessManager = new CreateServerlessManager();
    }

    public void create(
            ToolkitProfile profile,
            ToolkitCreateConfig createConfig,
            ToolkitDeployConfig deployConfig,
            ToolkitPackageConfig entityConfig) throws Exception {
        if (!Constants.APP_CREATION.equalsIgnoreCase(createConfig.getKind())) {
            throw new Exception("kind is not AppCreation in toolkit create file.");
        }

        ToolkitCreateConfig.Spec spec = createConfig.getSpec();
        if (spec == null) {
            spec = new ToolkitCreateConfig.Spec();
            createConfig.setSpec(spec);
        }

        String type = spec.getType();
        if (Constants.SERVERLESS.equalsIgnoreCase(type)) {
            createServerlessManager.create(profile, createConfig, deployConfig, entityConfig);
            return;
        }

        throw new Exception("Unknown type in creation: " + type);
    }
}
