package com.aliyun.mojo;

import com.aliyun.Context;
import com.aliyun.bean.common.BuildProfile;
import com.aliyun.bean.config.DefaultConfigBean;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.manager.config.ToolkitPackageConfigManager;
import com.aliyun.manager.config.ToolkitCreateConfigManager;
import com.aliyun.manager.config.ToolkitDeployConfigManager;
import com.aliyun.manager.config.ToolkitProfileConfigManager;
import com.aliyun.manager.create.ToolkitCreateManager;
import com.aliyun.utils.CommonUtils;
import com.aliyuncs.DefaultAcsClient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

import java.io.File;

import static com.aliyun.enums.Constants.*;

@Mojo( name = "create", defaultPhase = LifecyclePhase.PACKAGE)
public class ToolkitCreateMojo extends AbstractMojo {
    private static final String DEFAULT_CONFIG_FILE = ".toolkit_create.yaml";

    @Parameter(readonly = true, defaultValue = "${project}")
    private MavenProject project;

    //path to profile
    @Parameter(property = "toolkit_profile")
    private String toolkitProfile;

    //path to toolkit_create config file
    @Parameter(property = "toolkit_create")
    private String toolkitCreate;

    @Parameter(property = "toolkit_package")
    private String toolkitPackage;

    //path to toolkit_create config file
    @Parameter(property = "toolkit_deploy")
    private String toolkitDeploy;

    @Parameter(property = "accessKeyId")
    private String accessKeyId;

    @Parameter(property = "accessKeySecret")
    private String accessKeySecret;

    @Parameter(property = "accessKeyFile")
    private String accessKeyFile;

    private DefaultConfigBean config;

    public void execute() throws MojoExecutionException {
        Context.setLogger(getLog());
        Context.setProject(project);
        loadProperties();
        initAcsClient();

        try {
            ToolkitCreateManager createManager = new ToolkitCreateManager();
            createManager.create(
                    Context.getToolkitProfileConfig(), Context.getToolkitCreateConfig(),
                    Context.getToolkitDeployConfig(), Context.getToolkitPackageConfig());
        } catch (Exception ex) {
            String msg = "Failed to create: " + ex.getMessage();
            getLog().error(msg, ex);
            throw new MojoExecutionException(msg);
        }
    }

    private void initAcsClient() throws MojoExecutionException {
        try {
            DefaultAcsClient client = CommonUtils.initAcsClient(Context.getToolkitProfileConfig());
            Context.setAcsClient(client);
        } catch (Exception ex) {
            String msg = "Failed to init acs client: " + ex.getMessage();
            getLog().error(msg, ex);
            throw new MojoExecutionException(msg);
        }
    }

    private void loadProperties() throws MojoExecutionException {
        //private  profileConfigManager;
        ToolkitCreateConfigManager createConfigManager = new ToolkitCreateConfigManager();
        ToolkitProfileConfigManager profileConfigManager = new ToolkitProfileConfigManager();

        File baseDir = project.getBasedir();
        //profile
        String defaultProfile = baseDir.getPath() + CommonUtils.getFileSeparator() + TOOLKIT_DEFAULT_PROFILE;
        Context.setToolkitProfileConfig(profileConfigManager.loadProperties(
                toolkitProfile, defaultProfile, accessKeyId, accessKeySecret));
        //create config
        String defaultFile = baseDir.getPath() + CommonUtils.getFileSeparator() + DEFAULT_CONFIG_FILE;
        Context.setToolkitCreateConfig(createConfigManager.loadProperties(toolkitCreate, defaultFile));
        //package config
        String defaultPackageFile =
                baseDir.getPath() + CommonUtils.getFileSeparator() + TOOLKIT_DEFAULT_PACKAGE_CONFIG;
        ToolkitPackageConfigManager packageConfigManager = new ToolkitPackageConfigManager();
        ToolkitPackageConfig packageConfig =
                packageConfigManager.loadProperties(toolkitPackage, defaultPackageFile);
        if (packageConfig.getSpec().getBuild() == null) {
            packageConfig.getSpec().setBuild(new BuildProfile());
        }
        Context.setToolkitPackageConfig(packageConfig);
        //deploy config
        String newDefaultDeployFile = baseDir.getPath() + CommonUtils.getFileSeparator() + TOOLKIT_DEFAULT_DEPLOY_CONFIG;
        ToolkitDeployConfigManager deployConfigManager = new ToolkitDeployConfigManager();
        ToolkitDeployConfig deployConfig =
                deployConfigManager.loadProperties(toolkitDeploy, newDefaultDeployFile);
        Context.setToolkitDeployConfig(deployConfig);
    }
}
