package com.aliyun.utils;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.enums.Constants;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.Closeable;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class CommonUtils {

    public enum Product {
        Edas, Sae
    }

//    public static Log logger;

//    static {
//        try {
//            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", "Edas", "edas.cn-hangzhou.aliyuncs.com");
//            DefaultProfile.addEndpoint("cn-beijing", "cn-beijing", "Edas", "edas.cn-beijing.aliyuncs.com");
//            DefaultProfile.addEndpoint("cn-shanghai", "cn-shanghai", "Edas", "edas.cn-shanghai.aliyuncs.com");
//            DefaultProfile.addEndpoint("cn-shenzhen", "cn-shenzhen", "Edas", "edas.cn-shenzhen.aliyuncs.com");
//            DefaultProfile.addEndpoint("cn-qingdao", "cn-qingdao", "Edas", "edas.cn-qingdao.aliyuncs.com");
//            DefaultProfile.addEndpoint("ap-southeast-1", "ap-southeast-1", "Edas", "edas.ap-southeast-1.aliyuncs.com");
//        } catch (Exception ex) {
//            ex.printStackTrace();
//        }
//    }

//    public static DefaultAcsClient getACSClient(DefaultConfigBean config) throws ClientException {
////        DefaultConfigBean.Env env = config.getEnv();
////        DefaultProfile defaultProfile = DefaultProfile.getProfile(env.getRegionId(),
////            env.getAccessKeyId(), env.getAccessKeySecret());
////        DefaultAcsClient client = new DefaultAcsClient(defaultProfile);
////        client.setAutoRetry(false);
////        return client;
////    }

    public static DefaultAcsClient initAcsClient(ToolkitProfile toolkitProfile) throws Exception {
        String product = isEmpty(toolkitProfile.getProduct()) ? Product.Edas.name() : toolkitProfile.getProduct();
        DefaultProfile.addEndpoint(
                toolkitProfile.getRegionId(), toolkitProfile.getRegionId(),
            product, toolkitProfile.getEndpoint());

        DefaultProfile defaultProfile = DefaultProfile.getProfile(toolkitProfile.getRegionId(),
                toolkitProfile.getAccessKeyId(), toolkitProfile.getAccessKeySecret());

        DefaultAcsClient defaultAcsClient = new DefaultAcsClient(defaultProfile);
        defaultAcsClient.setAutoRetry(false);
        return defaultAcsClient;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        } else if (obj instanceof String) {
            return "".equals(String.valueOf(obj).trim());
        } else if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        } else if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        } else {
            return obj instanceof Map ? ((Map)obj).isEmpty() : false;
        }
    }

    public static boolean isNotEmpty(Object obj) {
        return !isEmpty(obj);
    }

//    public static void initLogger(Log logger) {
//        CommonUtils.logger = logger;
//    }

    public static String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        } catch (Exception ex) {
            //ignore
        }
    }

    public static String getPopApiRouteKey() {
        if (System.getProperty(Constants.POP_API_ROUTE_KEY) != null) {
            return System.getProperty(Constants.POP_API_ROUTE_KEY);
        }

        if (System.getenv(Constants.POP_API_ROUTE_KEY) != null) {
            return System.getenv(Constants.POP_API_ROUTE_KEY);
        }

        return null;
    }
}