package com.aliyun.utils;

import java.io.InputStream;
import java.util.Properties;

public class PluginUtils {
    private static String version = null;
    public static String getVersion() {
        if (version != null) {
            return version;
        }

        InputStream is = null;
        try {
            is = PluginUtils.class.getClassLoader().getResourceAsStream("plugin.information");
            Properties properties = new Properties();
            properties.load(is);
            version = properties.getProperty("toolkit.maven_plugin.version");
        } catch (Exception ex) {
            //ignore
        } finally {
            CommonUtils.close(is);
        }

        if (version == null) {
            version = "unknown";
        }

        return "cloud-toolkit-" + version;
    }
}
