/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.utils.CommonUtils;
import com.aliyun.utils.HttpUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.edas.model.v20170801.ListApplicationRequest;
import com.aliyuncs.edas.model.v20170801.ListApplicationResponse;
import com.aliyuncs.sae.model.v20190506.ListApplicationsRequest;
import com.aliyuncs.sae.model.v20190506.ListApplicationsResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class AppConfigManager {
    private Log logger = Context.getLogger();

    public void complete(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig, MavenProject project, DefaultAcsClient acsClient) throws Exception {
        this.fixAppId(deployConfig, acsClient);
        String type = deployConfig.getSpec().getType();
        if ("serverless".equals(type)) {
            this.setDefaultConfigForServerless(deployConfig, project);
        } else {
            this.setDefaultConfigForNonServerless(deployConfig, packageConfig, project);
        }
    }

    private void fixAppId(ToolkitDeployConfig deployConfig, DefaultAcsClient acsClient) throws Exception {
        if (deployConfig.getSpec().getTarget() == null) {
            deployConfig.getSpec().setTarget(new ToolkitDeployConfig.Target());
        }
        if (!"serverless".equals(deployConfig.getSpec().getType())) {
            this.tryToFixAppId(deployConfig.getSpec(), acsClient);
        } else if (deployConfig.getSpec().getTarget().getAppId() == null) {
            this.tryToFixAppIdServerless(deployConfig.getSpec(), acsClient);
        }
        if (deployConfig.getSpec().getTarget().getAppId() == null) {
            throw new Exception("'appId' is not set");
        }
    }

    private void tryToFixAppId(ToolkitDeployConfig.Spec spec, DefaultAcsClient client) throws Exception {
        if ((spec.getTarget().getNamespaceId() == null || spec.getTarget().getAppName() == null) && spec.getTarget().getAppId() == null) {
            return;
        }
        this.logger.info((CharSequence)String.format("fix appId(%s)", spec.getTarget().getAppId()));
        ListApplicationRequest request = new ListApplicationRequest();
        ListApplicationResponse response = (ListApplicationResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)client, request);
        if (response.getCode() != 200) {
            return;
        }
        for (ListApplicationResponse.Application application : response.getApplicationList()) {
            if ((!application.getRegionId().equals(spec.getTarget().getNamespaceId()) || !application.getName().equals(spec.getTarget().getAppName())) && !application.getAppId().equals(spec.getTarget().getAppId())) continue;
            this.logger.info((CharSequence)String.format("Use app id for app(%s) in namespace(%s)", application.getName(), application.getRegionId()));
            spec.getTarget().setAppId(application.getAppId());
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            this.logger.info((CharSequence)String.format("fix appId application = (%s) \n", jsonMapper.writeValueAsString((Object)application)));
            if (application.getClusterType() == 5) {
                spec.setType("kubernetes");
            }
            return;
        }
    }

    private void tryToFixAppIdServerless(ToolkitDeployConfig.Spec spec, DefaultAcsClient client) throws Exception {
        if (spec.getTarget().getNamespaceId() == null || spec.getTarget().getAppName() == null) {
            return;
        }
        ListApplicationsRequest request = new ListApplicationsRequest();
        request.setAppName(spec.getTarget().getAppName());
        ListApplicationsResponse response = (ListApplicationsResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)client, request);
        if (!"200".equals(response.getCode())) {
            return;
        }
        for (ListApplicationsResponse.Data.Application application : response.getData().getApplications()) {
            String nameSpaceId = application.getNamespaceId() != null ? application.getNamespaceId() : application.getRegionId();
            if (!nameSpaceId.equals(spec.getTarget().getNamespaceId()) || !application.getAppName().equals(spec.getTarget().getAppName())) continue;
            this.logger.info((CharSequence)String.format("Use app id for app(%s) in namespace(%s)", spec.getTarget().getAppName(), spec.getTarget().getNamespaceId()));
            spec.getTarget().setAppId(application.getAppId());
            return;
        }
    }

    private void setDefaultConfigForServerless(ToolkitDeployConfig deployConfig, MavenProject project) {
        deployConfig.getSpec().setStageTimeout(300);
        deployConfig.getSpec().setServiceStageTimeout(300);
        deployConfig.getSpec().setInstanceStageTimeout(300);
        if (deployConfig.getSpec().getVersion() == null) {
            deployConfig.getSpec().setVersion(new SimpleDateFormat("ddHHmmss").format(new Date()));
        }
    }

    private void setDefaultConfigForNonServerless(ToolkitDeployConfig deployConfig, ToolkitPackageConfig packageConfig, MavenProject project) {
        int batchWaitTime;
        if (packageConfig.getSpec().getPackageType() == null) {
            packageConfig.getSpec().setPackageType("url");
        }
        if (deployConfig.getSpec().getBatch() == null) {
            deployConfig.getSpec().setBatch(1);
        }
        if (deployConfig.getSpec().getGroupId() == null) {
            deployConfig.getSpec().setGroupId("all");
        }
        int n = batchWaitTime = deployConfig.getSpec().getBatchWaitTime() != null ? deployConfig.getSpec().getBatchWaitTime() : 0;
        if (deployConfig.getSpec().getStageTimeout() == null) {
            deployConfig.getSpec().setStageTimeout(batchWaitTime * 60 + 300);
        } else {
            int seconds = batchWaitTime * 60 + deployConfig.getSpec().getStageTimeout() * 60;
            deployConfig.getSpec().setStageTimeout(seconds);
        }
        if (deployConfig.getSpec().getVersion() == null) {
            String pv = String.format("%s (%s)", project.getVersion(), CommonUtils.getCurrentTime());
            deployConfig.getSpec().setVersion(pv);
        }
        deployConfig.getSpec().setServiceStageTimeout(deployConfig.getSpec().getStageTimeout());
        deployConfig.getSpec().setInstanceStageTimeout(deployConfig.getSpec().getStageTimeout());
    }
}

