/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.config.RunningEnvironment;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.utils.CommonUtils;
import com.aliyun.utils.HttpUtils;
import com.aliyun.utils.PluginUtils;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.edas.model.v20170801.DeployApplicationRequest;
import com.aliyuncs.edas.model.v20170801.DeployK8sApplicationRequest;
import com.aliyuncs.edas.model.v20170801.DeployK8sApplicationResponse;
import com.aliyuncs.edas.model.v20170801.GetK8sApplicationRequest;
import com.aliyuncs.edas.model.v20170801.GetK8sApplicationResponse;
import com.aliyuncs.sae.model.v20190506.DeployApplicationResponse;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class DeployPackageManager {
    private Log logger = Context.getLogger();

    public String deployPackage(DefaultAcsClient defaultAcsClient, ToolkitDeployConfig deployConfig, ToolkitPackageConfig entityConfig) throws Exception {
        if ("serverless".equals(deployConfig.getSpec().getType())) {
            return this.deployServerlessPackage(deployConfig, entityConfig, defaultAcsClient);
        }
        if ("kubernetes".equals(deployConfig.getSpec().getType())) {
            return this.deployKubernetesPackage(deployConfig, entityConfig, defaultAcsClient);
        }
        return this.deployNonServerlessPackage(deployConfig, entityConfig, defaultAcsClient);
    }

    private String deployServerlessPackage(ToolkitDeployConfig deployConfig, ToolkitPackageConfig entityConfig, DefaultAcsClient defaultAcsClient) throws Exception {
        DeployApplicationResponse response;
        ToolkitDeployConfig.Spec spec = deployConfig.getSpec();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        com.aliyuncs.sae.model.v20190506.DeployApplicationRequest request = new com.aliyuncs.sae.model.v20190506.DeployApplicationRequest();
        request.putHeaderParameter("X-EDAS-DEPLOY-SOURCE", PluginUtils.getVersion());
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
        }
        request.setAppId(deployConfig.getSpec().getTarget().getAppId());
        request.setPackageUrl(entityConfig.getSpec().getPackageUrl());
        request.setPackageVersion(deployConfig.getSpec().getVersion());
        if (entityConfig.getSpec().getImageUrl() != null) {
            request.setImageUrl(entityConfig.getSpec().getImageUrl());
        }
        if (spec.getBatchWaitTime() != null) {
            request.setBatchWaitTime(spec.getBatchWaitTime());
        }
        if (spec.getJdk() != null) {
            request.setJdk(spec.getJdk());
        }
        if (deployConfig.getSpec().getWebContainer() != null) {
            request.setWebContainer(deployConfig.getSpec().getWebContainer());
        }
        if (spec.getCommand() != null) {
            request.setCommand(spec.getCommand());
        }
        if (spec.getCommandArgs() != null) {
            request.setCommandArgs(jsonMapper.writeValueAsString(spec.getCommandArgs()));
        }
        if (spec.getJarStartOptions() != null) {
            request.setJarStartOptions(spec.getJarStartOptions());
        }
        if (spec.getJarStartArgs() != null) {
            request.setJarStartArgs(spec.getJarStartArgs());
        }
        if (spec.getEnvs() != null) {
            request.setEnvs(jsonMapper.writeValueAsString(spec.getEnvs()));
        }
        if (spec.getCustomHostAlias() != null) {
            request.setCustomHostAlias(jsonMapper.writeValueAsString(spec.getCustomHostAlias()));
        }
        if (spec.getLiveness() != null) {
            request.setLiveness(spec.getLiveness());
        }
        if (spec.getReadiness() != null) {
            request.setReadiness(spec.getReadiness());
        }
        if (spec.getMinReadyInstances() != null) {
            request.setMinReadyInstances(spec.getMinReadyInstances());
        }
        if ("200".equals((response = (DeployApplicationResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request)).getCode())) {
            return response.getData().getChangeOrderId();
        }
        String msg = String.format("Failed to send deploy request, requestId: %s, code: %s, msg: %s", response.getRequestId(), response.getCode(), response.getMessage());
        HttpUtils.postJson("https://open.feishu.cn/open-apis/bot/v2/hook/e8867f8c-709d-4357-84af-aec7090b7ed2", "{\"msg_type\":\"text\",\"content\":{\"text\":\"\u540e\u7aef\u90e8\u7f72\u5931\u8d25!. " + msg + " \"}}", 5000);
        throw new Exception(msg);
    }

    private String deployNonServerlessPackage(ToolkitDeployConfig deployConfig, ToolkitPackageConfig entityConfig, DefaultAcsClient defaultAcsClient) throws Exception {
        ToolkitDeployConfig.Spec deployConfigSpec = deployConfig.getSpec();
        DeployApplicationRequest request = new DeployApplicationRequest();
        request.putHeaderParameter("X-EDAS-DEPLOY-SOURCE", PluginUtils.getVersion());
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
        }
        request.setAppId(deployConfig.getSpec().getTarget().getAppId());
        request.setGroupId(deployConfigSpec.getGroupId());
        if (entityConfig.getSpec().getPackageUrl() != null) {
            request.setDeployType("url");
            request.setWarUrl(entityConfig.getSpec().getPackageUrl());
        } else {
            request.setDeployType("image");
            request.setImageUrl(entityConfig.getSpec().getImageUrl());
        }
        if (deployConfigSpec.getBatch() != null) {
            request.setBatch(deployConfigSpec.getBatch());
        }
        if (deployConfigSpec.getBatchWaitTime() != null) {
            request.setBatchWaitTime(deployConfigSpec.getBatchWaitTime());
        }
        if (deployConfigSpec.getVersion() != null) {
            request.setPackageVersion(deployConfigSpec.getVersion());
        } else {
            request.setPackageVersion(CommonUtils.getCurrentTime());
        }
        if (deployConfigSpec.getDesc() != null) {
            request.setDesc(deployConfigSpec.getDesc());
        }
        this.logger.info((CharSequence)"Sending deploy request to EDAS...");
        com.aliyuncs.edas.model.v20170801.DeployApplicationResponse response = (com.aliyuncs.edas.model.v20170801.DeployApplicationResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request);
        if (response.getCode() == 200) {
            String changeOrderId = response.getChangeOrderId();
            this.logger.info((CharSequence)("Deploy request sent, changeOrderId is: " + changeOrderId));
            return changeOrderId;
        }
        String msg = String.format("Failed to send deploy request, requestId: %s, code: %d, msg: %s", response.getRequestId(), response.getCode(), response.getMessage());
        HttpUtils.postJson("https://open.feishu.cn/open-apis/bot/v2/hook/e8867f8c-709d-4357-84af-aec7090b7ed2", "{\"msg_type\":\"text\",\"content\":{\"text\":\"\u540e\u7aef\u90e8\u7f72\u5931\u8d25!. " + msg + " \"}}", 5000);
        throw new Exception(msg);
    }

    private String deployKubernetesPackage(ToolkitDeployConfig deployConfig, ToolkitPackageConfig entityConfig, DefaultAcsClient defaultAcsClient) throws Exception {
        DeployK8sApplicationResponse response;
        String changeOrderDesc;
        String yyyy_mm_dd_hh_mm_ss = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(new Date());
        String buildUser = System.getProperty("BUILD_USER", System.getenv("BUILD_USER"));
        String changeLog = System.getProperty("CHANGE_LOG", System.getenv("CHANGE_LOG"));
        String packageUrl = entityConfig.getSpec().getPackageUrl();
        String packageVersion = deployConfig.getSpec().getVersion();
        if (changeLog == null) {
            changeLog = "";
        }
        if (buildUser == null) {
            buildUser = "";
        }
        buildUser = buildUser.replace(".", "_");
        RunningEnvironment runningEnvironment = this.getK8sAppRunningEnvironment(deployConfig.getSpec().getTarget().getAppId(), defaultAcsClient);
        ToolkitDeployConfig.Spec spec = deployConfig.getSpec();
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DeployK8sApplicationRequest request = new DeployK8sApplicationRequest();
        request.putHeaderParameter("X-EDAS-DEPLOY-SOURCE", PluginUtils.getVersion());
        String routeKey = CommonUtils.getPopApiRouteKey();
        if (routeKey != null) {
            request.putHeaderParameter("X-EDAS-AT-ROUTER-KEY", routeKey);
        }
        request.setAppId(deployConfig.getSpec().getTarget().getAppId());
        if ("Image".equals(entityConfig.getSpec().getPackageType())) {
            if (entityConfig.getSpec().getImageUrl() != null) {
                request.setImage(entityConfig.getSpec().getImageUrl());
            }
        } else {
            request.setPackageUrl(entityConfig.getSpec().getPackageUrl());
            request.setPackageVersion(deployConfig.getSpec().getVersion());
        }
        if (spec.getLocalVolume() != null) {
            request.setLocalVolume(spec.getLocalVolume());
        }
        if (spec.getStorageType() != null) {
            request.setStorageType(spec.getStorageType());
        }
        if (spec.getBatchWaitTime() != null) {
            request.setBatchWaitTime(spec.getBatchWaitTime());
        }
        if (spec.getUpdateStrategy() != null) {
            request.setUpdateStrategy(spec.getUpdateStrategy());
        }
        if (spec.getReplicas() != null) {
            request.setReplicas(spec.getReplicas());
        }
        if (spec.getMemoryLimit() != null) {
            request.setMemoryLimit(spec.getMemoryLimit());
        }
        if (spec.getMemoryRequest() != null) {
            request.setMemoryRequest(spec.getMemoryRequest());
        }
        if (spec.getCpuLimit() != null) {
            request.putQueryParameter("CpuLimit", (Object)spec.getCpuLimit());
        }
        if (spec.getCpuRequest() != null) {
            request.putQueryParameter("CpuRequest", (Object)spec.getCpuRequest());
        }
        if (spec.getMcpuLimit() != null) {
            request.putQueryParameter("McpuLimit", (Object)spec.getMcpuLimit());
        }
        if (spec.getMcpuRequest() != null) {
            request.putQueryParameter("McpuRequest", (Object)spec.getMcpuRequest());
        }
        if (spec.getEnableAhas() != null) {
            request.setEnableAhas(spec.getEnableAhas());
        }
        if ((changeOrderDesc = spec.getChangeOrderDesc()) != null) {
            changeOrderDesc = changeOrderDesc.replaceAll("[$: ]", "").replaceAll("\\{timestamp}", yyyy_mm_dd_hh_mm_ss).replaceAll("\\{build_user}", buildUser).replaceAll("\\{package_url}", packageUrl).replaceAll("\\{package_version}", packageVersion).replaceAll("\\{change_log}", changeLog);
            if (StringUtils.isNotBlank((String)changeLog) && StringUtils.isBlank((String)changeOrderDesc)) {
                changeOrderDesc = changeLog;
            }
            request.setChangeOrderDesc(changeOrderDesc);
        }
        if (spec.getDeployAcrossZones() != null) {
            request.setDeployAcrossZones(spec.getDeployAcrossZones().toString());
        }
        if (spec.getDeployAcrossNodes() != null) {
            request.putQueryParameter("DeployAcrossNodes", (Object)spec.getDeployAcrossNodes().toString());
        }
        if (spec.getJdk() != null) {
            request.setJDK(spec.getJdk());
        } else {
            request.setJDK(runningEnvironment.getJdk());
        }
        if (deployConfig.getSpec().getWebContainer() != null) {
            request.setWebContainer(deployConfig.getSpec().getWebContainer());
        } else {
            request.setWebContainer(runningEnvironment.getWebContainer());
        }
        if (spec.getCommand() != null) {
            request.setCommand(spec.getCommand());
        }
        if (spec.getCommandArgs() != null) {
            request.setArgs(jsonMapper.writeValueAsString(spec.getCommandArgs()));
        }
        if (spec.getEnvs() != null) {
            request.setEnvs(jsonMapper.writeValueAsString(spec.getEnvs()));
        }
        if (spec.getLiveness() != null) {
            request.setLiveness(spec.getLiveness());
        }
        if (spec.getReadiness() != null) {
            request.setReadiness(spec.getReadiness());
        }
        if ((response = (DeployK8sApplicationResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request)).getCode() == 200) {
            String changeOrderId = response.getChangeOrderId();
            this.logger.info((CharSequence)("Deploy k8s application request sent, changeOrderId is: " + changeOrderId));
            return changeOrderId;
        }
        String msg = String.format("Failed to send deploy k8s application request, requestId: %s, code: %d, msg: %s", response.getRequestId(), response.getCode(), response.getMessage());
        HttpUtils.postJson("https://open.feishu.cn/open-apis/bot/v2/hook/e8867f8c-709d-4357-84af-aec7090b7ed2", "{\"msg_type\":\"text\",\"content\":{\"text\":\"\u540e\u7aef\u90e8\u7f72\u5931\u8d25!. " + msg + " \"}}", 5000);
        throw new Exception(msg);
    }

    public RunningEnvironment getK8sAppRunningEnvironment(String appId, DefaultAcsClient defaultAcsClient) throws Exception {
        if (StringUtils.isBlank((String)appId)) {
            throw new Exception("Application must be selected");
        }
        RunningEnvironment runningEnvironment = new RunningEnvironment();
        GetK8sApplicationRequest request = new GetK8sApplicationRequest();
        request.setAppId(appId);
        request.setFrom("deploy");
        GetK8sApplicationResponse response = (GetK8sApplicationResponse)HttpUtils.getAcsResponseIfRetry((IAcsClient)defaultAcsClient, request);
        if (response.getCode() == 200) {
            if (response.getApplcation().getDeployGroups().size() > 0) {
                for (GetK8sApplicationResponse.Applcation.DeployGroup.ComponentsItem componentsItem : ((GetK8sApplicationResponse.Applcation.DeployGroup)response.getApplcation().getDeployGroups().get(0)).getComponents()) {
                    if (!componentsItem.getComponentKey().startsWith("Open JDK")) continue;
                    runningEnvironment.setJdk(componentsItem.getComponentKey());
                }
            }
            if (response.getApplcation().getApp().getBuildpackId() == -1 && response.getApplcation().getApp().getApplicationType().equals("War")) {
                if (response.getApplcation().getDeployGroups().size() > 0) {
                    for (GetK8sApplicationResponse.Applcation.DeployGroup.ComponentsItem componentsItem : ((GetK8sApplicationResponse.Applcation.DeployGroup)response.getApplcation().getDeployGroups().get(0)).getComponents()) {
                        if (!componentsItem.getComponentKey().startsWith("apache-tomcat-")) continue;
                        runningEnvironment.setWebContainer(componentsItem.getComponentKey());
                    }
                } else {
                    runningEnvironment.setWebContainer("apache-tomcat-7.0.91");
                }
            } else {
                runningEnvironment.setWebContainer("");
            }
            return runningEnvironment;
        }
        throw new Exception(response.getMessage());
    }
}

