/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager;

import com.aliyun.Context;
import com.aliyun.bean.config.AliyunConfigBean;
import com.aliyun.bean.config.DefaultConfigBean;
import com.aliyun.utils.CommonUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

@Deprecated
public class LoadConfigManager {
    private static final String ACCESS_KEY_ID = "access_key_id";
    private static final String ACCESS_KEY_SECRET = "access_key_secret";
    String SEPARATOR = System.getProperty("file.separator");
    private MavenProject project = Context.getProject();
    private Log logger = Context.getLogger();
    private ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private ObjectMapper jsonMapper;

    public LoadConfigManager() {
        this.yamlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.yamlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public DefaultConfigBean loadProperties(String configFile, String defaultConfigFile, String accessKeyFile, String accessKeyId, String accessKeySecret) throws Exception {
        DefaultConfigBean config = this.loadConfigFile(configFile, defaultConfigFile);
        this.checkAndOverwriteAccessKey(config, accessKeyFile, accessKeyId, accessKeySecret);
        this.setEndpoint(config);
        return config;
    }

    private DefaultConfigBean loadConfigFile(String configFile, String defaultConfigFile) throws Exception {
        DefaultConfigBean config;
        File file = configFile != null ? new File(configFile) : new File(defaultConfigFile);
        if (!file.exists()) {
            throw new Exception("No config file is found: " + file.getAbsolutePath());
        }
        try {
            config = (DefaultConfigBean)this.yamlMapper.readValue(file, DefaultConfigBean.class);
            if (config.getEnv() == null) {
                config.setEnv(new DefaultConfigBean.Env());
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            throw new Exception(ex.getMessage());
        }
        return config;
    }

    private void setEndpoint(DefaultConfigBean config) {
        DefaultConfigBean.Env env = config.getEnv();
        if (env.getEndpoint() == null) {
            if (CommonUtils.isNotEmpty(config.getApp()) && "serverless".equalsIgnoreCase(config.getApp().getType())) {
                env.setEndpoint("sae." + env.getRegionId() + ".aliyuncs.com");
            } else {
                env.setEndpoint("edas." + env.getRegionId() + ".aliyuncs.com");
            }
        }
    }

    private void checkAndOverwriteAccessKey(DefaultConfigBean config, String accessKeyFile, String accessKeyId, String accessKeySecret) throws Exception {
        if (this.loadAkSkFromCommandLine(config, accessKeyId, accessKeySecret)) {
            return;
        }
        if (this.loadAkSkFromCustomFile(config, accessKeyFile)) {
            return;
        }
        if (this.loadAkSkFromEdasConfig(config)) {
            return;
        }
        if (this.loadAkSkFromAliyunConfig(config)) {
            return;
        }
        if (this.loadAkSkFromSystemEnv(config)) {
            return;
        }
        throw new Exception(String.format("'%s' or '%s' is not specified.", ACCESS_KEY_ID, ACCESS_KEY_SECRET));
    }

    private boolean loadAkSkFromSystemEnv(DefaultConfigBean config) {
        String ak = System.getenv(ACCESS_KEY_ID);
        String sk = System.getenv(ACCESS_KEY_SECRET);
        if (CommonUtils.isNotEmpty(ak) && CommonUtils.isNotEmpty(sk)) {
            config.getEnv().setAccessKeyId(ak);
            config.getEnv().setAccessKeySecret(sk);
            this.logger.info((CharSequence)"Use the ak/sk specified in system environment.");
            return true;
        }
        return false;
    }

    private boolean loadAkSkFromEdasConfig(DefaultConfigBean config) {
        return config.getEnv().getAccessKeyId() != null && config.getEnv().getAccessKeySecret() != null;
    }

    private boolean loadAkSkFromCommandLine(DefaultConfigBean config, String accessKeyId, String accessKeySecret) {
        if (accessKeyId != null && accessKeySecret != null) {
            config.getEnv().setAccessKeyId(accessKeyId);
            config.getEnv().setAccessKeySecret(accessKeySecret);
            this.logger.info((CharSequence)"Use the ak/sk specified in maven command line parameters.");
            return true;
        }
        return false;
    }

    private boolean loadAkSkFromCustomFile(DefaultConfigBean config, String accessKeyFile) throws Exception {
        try {
            if (accessKeyFile != null) {
                Map map = (Map)this.yamlMapper.readValue(new File(accessKeyFile), Map.class);
                String ak = String.valueOf(map.get(ACCESS_KEY_ID));
                String sk = String.valueOf(map.get(ACCESS_KEY_SECRET));
                if (ak == null) {
                    throw new Exception(String.format("No '%s' is found in %s", ACCESS_KEY_ID, accessKeyFile));
                }
                if (sk == null) {
                    throw new Exception(String.format("No '%s' is found in %s", ACCESS_KEY_SECRET, accessKeyFile));
                }
                config.getEnv().setAccessKeyId(ak);
                config.getEnv().setAccessKeySecret(sk);
                this.logger.info((CharSequence)("Use the ak/sk specified in the file: " + accessKeyFile));
                return true;
            }
        }
        catch (FileNotFoundException ex) {
            this.logger.error((Throwable)ex);
            throw new Exception(accessKeyFile + " does not exists.");
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            String msg = String.format("%s load failed, please confirm that it is a valid yaml file , contains '%s' and '%s' field", accessKeyFile, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
            throw new Exception(msg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadAkSkFromAliyunConfig(DefaultConfigBean config) throws Exception {
        String aliyunConfigJson;
        File configJsonFile;
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        Pattern akPattern = Pattern.compile("aliyun_access_key_id\\s*=\\s*(.+)");
        Pattern skPattern = Pattern.compile("aliyun_access_key_secret\\s*=\\s*(.+)");
        String aliyunCliCredentials = userHome + separator + ".aliyuncli" + separator + "credentials";
        File credentialFile = new File(aliyunCliCredentials);
        BufferedReader reader = null;
        if (credentialFile.exists()) {
            block12: {
                boolean akMatcher2;
                try {
                    String line;
                    String ak = null;
                    String sk = null;
                    reader = new BufferedReader(new FileReader(credentialFile));
                    while ((line = reader.readLine()) != null) {
                        Matcher akMatcher2 = akPattern.matcher(line);
                        if (akMatcher2.find()) {
                            ak = akMatcher2.group(1).trim();
                            continue;
                        }
                        Matcher skMatcher = skPattern.matcher(line);
                        if (!skMatcher.find()) continue;
                        sk = skMatcher.group(1).trim();
                    }
                    if (ak == null || sk == null) break block12;
                    config.getEnv().setAccessKeyId(ak);
                    config.getEnv().setAccessKeySecret(sk);
                    this.logger.info((CharSequence)("Use the ak/sk specified in the aliyuncli default credential: " + aliyunCliCredentials));
                    akMatcher2 = true;
                }
                catch (Exception ex) {
                    try {
                        this.logger.warn((CharSequence)String.format("Load ak/sk from %s failed: %s", aliyunCliCredentials, ex.getMessage()));
                    }
                    catch (Throwable throwable) {
                        CommonUtils.close(reader);
                        throw throwable;
                    }
                    CommonUtils.close(reader);
                }
                CommonUtils.close(reader);
                return akMatcher2;
            }
            CommonUtils.close(reader);
        }
        if ((configJsonFile = new File(aliyunConfigJson = userHome + separator + ".aliyun" + separator + "config.json")).exists()) {
            try {
                AliyunConfigBean aliyunConfig = (AliyunConfigBean)this.jsonMapper.readValue(configJsonFile, AliyunConfigBean.class);
                List<AliyunConfigBean.Profile> profiles = aliyunConfig.getProfiles();
                if (profiles == null) {
                    return false;
                }
                for (AliyunConfigBean.Profile profile : profiles) {
                    if (!CommonUtils.isNotEmpty(profile.getAccessKeyId()) || !CommonUtils.isNotEmpty(profile.getAccessKeySecret())) continue;
                    config.getEnv().setAccessKeyId(profile.getAccessKeyId());
                    config.getEnv().setAccessKeySecret(profile.getAccessKeySecret());
                    this.logger.info((CharSequence)String.format("Use the ak/sk specified in the aliyun config[%s]: %s", profile.getName(), aliyunConfigJson));
                    return true;
                }
            }
            catch (IOException ex) {
                this.logger.warn((CharSequence)String.format("Load ak/sk from %s failed: %s", aliyunConfigJson, ex.getMessage()));
            }
        }
        return false;
    }

    private boolean equals(String a, String b) {
        return a != null && b != null && a.equals(b);
    }
}

