/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mojo;

import com.aliyun.Context;
import com.aliyun.bean.common.BuildProfile;
import com.aliyun.bean.config.DefaultConfigBean;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.manager.config.ToolkitCreateConfigManager;
import com.aliyun.manager.config.ToolkitDeployConfigManager;
import com.aliyun.manager.config.ToolkitPackageConfigManager;
import com.aliyun.manager.config.ToolkitProfileConfigManager;
import com.aliyun.manager.create.ToolkitCreateManager;
import com.aliyun.utils.CommonUtils;
import com.aliyuncs.DefaultAcsClient;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="create", defaultPhase=LifecyclePhase.PACKAGE)
public class ToolkitCreateMojo
extends AbstractMojo {
    private static final String DEFAULT_CONFIG_FILE = ".toolkit_create.yaml";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="toolkit_profile")
    private String toolkitProfile;
    @Parameter(property="toolkit_create")
    private String toolkitCreate;
    @Parameter(property="toolkit_package")
    private String toolkitPackage;
    @Parameter(property="toolkit_deploy")
    private String toolkitDeploy;
    @Parameter(property="accessKeyId")
    private String accessKeyId;
    @Parameter(property="accessKeySecret")
    private String accessKeySecret;
    @Parameter(property="accessKeyFile")
    private String accessKeyFile;
    private DefaultConfigBean config;

    public void execute() throws MojoExecutionException {
        Context.setLogger(this.getLog());
        Context.setProject(this.project);
        this.loadProperties();
        this.initAcsClient();
        try {
            ToolkitCreateManager createManager = new ToolkitCreateManager();
            createManager.create(Context.getToolkitProfileConfig(), Context.getToolkitCreateConfig(), Context.getToolkitDeployConfig(), Context.getToolkitPackageConfig());
        }
        catch (Exception ex) {
            String msg = "Failed to create: " + ex.getMessage();
            this.getLog().error((CharSequence)msg, (Throwable)ex);
            throw new MojoExecutionException(msg);
        }
    }

    private void initAcsClient() throws MojoExecutionException {
        try {
            DefaultAcsClient client = CommonUtils.initAcsClient(Context.getToolkitProfileConfig());
            Context.setAcsClient(client);
        }
        catch (Exception ex) {
            String msg = "Failed to init acs client: " + ex.getMessage();
            this.getLog().error((CharSequence)msg, (Throwable)ex);
            throw new MojoExecutionException(msg);
        }
    }

    private void loadProperties() throws MojoExecutionException {
        ToolkitCreateConfigManager createConfigManager = new ToolkitCreateConfigManager();
        ToolkitProfileConfigManager profileConfigManager = new ToolkitProfileConfigManager();
        File baseDir = this.project.getBasedir();
        String defaultProfile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_profile.yaml";
        Context.setToolkitProfileConfig(profileConfigManager.loadProperties(this.toolkitProfile, defaultProfile, this.accessKeyId, this.accessKeySecret));
        String defaultFile = baseDir.getPath() + CommonUtils.getFileSeparator() + DEFAULT_CONFIG_FILE;
        Context.setToolkitCreateConfig(createConfigManager.loadProperties(this.toolkitCreate, defaultFile));
        String defaultPackageFile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_package.yaml";
        ToolkitPackageConfigManager packageConfigManager = new ToolkitPackageConfigManager();
        ToolkitPackageConfig packageConfig = packageConfigManager.loadProperties(this.toolkitPackage, defaultPackageFile);
        if (packageConfig.getSpec().getBuild() == null) {
            packageConfig.getSpec().setBuild(new BuildProfile());
        }
        Context.setToolkitPackageConfig(packageConfig);
        String newDefaultDeployFile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_deploy.yaml";
        ToolkitDeployConfigManager deployConfigManager = new ToolkitDeployConfigManager();
        ToolkitDeployConfig deployConfig = deployConfigManager.loadProperties(this.toolkitDeploy, newDefaultDeployFile);
        Context.setToolkitDeployConfig(deployConfig);
    }
}

